package com.fr.plugin.filter;

import com.fr.decision.authority.data.User;
import com.fr.decision.fun.impl.AbstractGlobalRequestFilterProvider;
import com.fr.decision.webservice.utils.DecisionServiceConstants;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.log.FineLoggerFactory;
import com.fr.plugin.transform.FunctionRecorder;
import com.fr.third.jodd.util.StringUtil;
import com.fr.web.utils.WebUtils;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Base64;

@FunctionRecorder
public class AuthFilter extends AbstractGlobalRequestFilterProvider {
    @Override
    public String filterName() {
        return "everything";
    }
    @Override
    public String[] urlPatterns() {
        return new String[]{"/decision/*"};
    }
    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) {
        try{
            if(!isLogin(req)){
               String reqToken = req.getParameter("token");
               if(StringUtil.isNotBlank(reqToken)){
                   try{
                       String userName = new String(Base64.getUrlDecoder().decode(reqToken));
                       User user =  UserService.getInstance().getUserByUserName(userName);
                       if(user != null){
                           String token= LoginService.getInstance().login(req,res,userName);
                           req.setAttribute(DecisionServiceConstants.FINE_AUTH_TOKEN_NAME,token);
                       }else{
                           FineLoggerFactory.getLogger().error("登录用户不存在",userName);
                           WebUtils.printAsString(res,"Login user not exist:"+userName);
                           return ;
                       }
                   }catch (Exception e){
                       FineLoggerFactory.getLogger().error("登录过程异常",e);
                   }
               }
            }
            filterChain.doFilter(req,res);
        }catch (Exception e){
            FineLoggerFactory.getLogger().error("请求异常",e);
        }
    }
    private boolean isLogin(HttpServletRequest request){
        return LoginService.getInstance().isLogged(request);
    }
}
