package com.fr.plugin;

import com.fr.decision.authority.data.User;
import com.fr.decision.fun.impl.AbstractGlobalRequestFilterProvider;
import com.fr.decision.webservice.utils.DecisionServiceConstants;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.login.TokenResource;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import org.jasig.cas.client.validation.Assertion;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class FRLoginFilter extends AbstractGlobalRequestFilterProvider {
    @Override
    public String filterName() {
        return "login";
    }

    @Override
    public String[] urlPatterns() {
        return new String[]{"/*"};
    }

    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) {
        String casUser=getCasUser(req,res);
        if(isNeedLogin(casUser,req,res)){
            if(!LoginFR(casUser,req,res)){//登录帆软
                //登录失败的情况
            }
        }
        try {
            filterChain.doFilter(req,res);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ServletException e) {
            e.printStackTrace();
        }
    }

    private  Boolean isNeedLogin(String casUser, HttpServletRequest req, HttpServletResponse res){
        if(!isLoginedFR(req)){
            return  true;
        }
        String frUser= LoginService.getInstance().getCurrentUserNameFromRequestCookie(req);

        return !ComparatorUtils.equals(casUser,frUser);
    }
    /**
     * 获取cas用户
     * @param req
     * @param res
     * @return
     */
    private String getCasUser(HttpServletRequest req,HttpServletResponse res){
        String username;
        //获取cas传递过来的username
        Object object = req.getSession().getAttribute("_const_cas_assertion_");
        if (object != null) {
            Assertion assertion = (Assertion) object;
            username = assertion.getPrincipal().getName();
        } else {
            username = (String) req.getSession().getAttribute("edu.yale.its.tp.cas.client.filter.user");
        }
        return  username;
    }

    /**
     * 判断FR是否登录了
     * @param req
     * @return
     */
    private Boolean isLoginedFR(HttpServletRequest req){
        String token= TokenResource.COOKIE.getToken(req);
        return StringUtils.isNotBlank(token);
    }

    /**
     * 登录FR
     * @param username
     * @param req
     * @param res
     * @return
     */
    private  Boolean LoginFR(String username,HttpServletRequest req,HttpServletResponse res){
        try{
            User user = UserService.getInstance().getUserByUserName(username);
            if (user == null) {
                return  false;
            }
            String token = LoginService.getInstance().login(req, res, username);
            req.setAttribute(DecisionServiceConstants.FINE_AUTH_TOKEN_NAME, token);
            return  true;
        }catch (Exception e){
        }
        return  false;
    }
}
