package com.fr.plugin;
import com.fr.decision.authority.data.User;
import com.fr.decision.fun.impl.AbstractEmbedRequestFilterProvider;
import com.fr.decision.webservice.utils.DecisionServiceConstants;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.log.FineLoggerFactory;
import com.fr.plugin.transform.ExecuteFunctionRecord;
import com.fr.plugin.transform.FunctionRecorder;
import com.fr.stable.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Base64;

@FunctionRecorder
public class MyEmbedRequestFilterProvider extends AbstractEmbedRequestFilterProvider {
    @Override
    @ExecuteFunctionRecord
    public void filter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!isLogin(httpServletRequest)) {
            String my_token = httpServletRequest.getParameter("my_token");
            if (StringUtils.isNotBlank(my_token)) {
                try {
                    String userName = new String(Base64.getUrlDecoder().decode(my_token));
                    UserService userService = UserService.getInstance();

                    User user = userService.getUserByUserName(userName);
                    if (user != null) {
                        String token = LoginService.getInstance().login(httpServletRequest, httpServletResponse, userName);
                        httpServletRequest.setAttribute(DecisionServiceConstants.FINE_AUTH_TOKEN_NAME,token);
                    }
                    FineLoggerFactory.getLogger().info("{}Login success from my filter", userName);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isLogin(HttpServletRequest request) {
        return LoginService.getInstance().isLogged(request);
    }
}
