package com.fr.plugin.http.token;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONArray;
import com.fr.plugin.IpTokenPluginDecisionDBAccessProvider;
import com.fr.plugin.dao.UserTokenRelationDao;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

public class TokenListApi extends BaseHttpHandler {
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }

    @Override
    public String getPath() {
        return "/token/list";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DBAccessor dbAccessor = IpTokenPluginDecisionDBAccessProvider.getDbAccessor();
//        String userName = httpServletRequest.getParameter("userName");
        List<UserTokenEntity> entityList = dbAccessor.runQueryAction(daoContext -> {
            QueryCondition queryCondition = QueryFactory.create();
//            if (StringUtils.isNotBlank(userName)) {
//                queryCondition.addRestriction(RestrictionFactory.eq("userName", userName));
//            }
            List<UserTokenEntity> entityList1 = daoContext.getDAO(UserTokenRelationDao.class).find(queryCondition);
            return entityList1;
        });
        JSONArray jsonArray = JSONArray.create(entityList);
        WebUtils.printAsJSON(httpServletResponse, jsonArray);
    }
}
