;(function () {
    // 这个菜单是配置ip关系的
    // 对应ppt注册菜单【3.注册到管理系统节点】
    BI.config("dec.constant.system.tabs", function (items) {
        items.push({
            value: "ipToken",
            text: BI.i18nText("Ip配置"),  // 文字
            cardType: "dec.management.ipConfig"
        });
        return items;
    });
    // 示例1：向menus中加入百度搜索按钮，ppt的注册菜单1
    BI.config("dec.constant.menu.items", function (items) {
        items.push({
            value: "baidu",
            text: BI.i18nText("百度一下"),
            cardType: {
                src: "http://baidu.com"
            },
            cls: "analysis-menu-font"
        });
        return items;
    });

    // 这个是从系统自己实现的中拷贝出来的，进行了一点修改
    function resolvePath(path, isPublic) {
        if (!path || path[0] !== '/') {
            path = '/' + path;
        }
        return isPublic === true
            ? '/plugin/public/com.fr.plugin.7.mix.project' + path
            : '/plugin/private/com.fr.plugin.7.mix.project' + path;
    }

    // 组件实现，效果为使用绝对布局组件放置了一个iframe
    var ipConfig = BI.inherit(BI.Widget, {
        props: {
            baseCls: "ipConfig"
        },
        render: function () {
            var self = this;
            return {
                type: "bi.absolute",
                items: [
                    {
                        el: {
                            type: "bi.button",
                            text: "添加",
                            handler: function () {
                                var id = "addUserPane"
                                var that = this;
                                // 参考：https://fanruan.design/doc.html?post=df052e5842
                                BI.Popovers.create(id, {
                                    type: "bi.bar_popover",
                                    // String或者是json都行
                                    header: "添加ip限制",
                                    size: "small",
                                    body: {
                                        type: "bi.add.userTokenOrIp",
                                        cType: "ip",
                                        ref: function (e) {
                                            that.userIpPane = e;
                                        }
                                    },
                                    listeners: [{
                                        eventName: "EVENT_CANCEL",
                                        action: function () {
                                            // $("#xxxx").on("click",function (){
                                            //
                                            // })
                                            BI.Msg.toast("点击了取消")
                                        }
                                    }, {
                                        eventName: "EVENT_CONFIRM",
                                        action: function () {
                                            var params = that.userIpPane.getValue();
                                            console.info(params)
                                            Dec.reqPost(resolvePath("/ip/add", false), {
                                                userName: params.userName,
                                                ip: params.params2
                                            }, function () {
                                                BI.Msg.toast("保存成功")
                                                self.tableRef.reload();
                                            })
                                        }
                                    }]
                                }).open(id);
                            }
                        },
                        top: 0,
                        left: 0
                    },
                    {
                        el: {
                            type: "bi.button",
                            text: "刷新",
                            handler: function () {
                                self.tableRef.reload();
                            }
                        },
                        top: 0,
                        left: 100
                    },
                    {
                        el: {
                            type: "dec.management.iptoken.table",
                            tableType: "ipTable",
                            ref: function (e) {
                                self.tableRef = e;
                            }
                        },
                        top: 40,
                        left: 0,
                        right: 0,
                        bottom: 0
                    }
                ]
            };
        }
    });
    BI.shortcut("dec.management.ipConfig", ipConfig);
})();
