;(function () {


    function resolvePath(path, isPublic) {
        if (!path || path[0] !== '/') {
            path = '/' + path;
        }
        return isPublic === true
            ? '/plugin/public/com.fr.plugin.7.mix.project' + path
            : '/plugin/private/com.fr.plugin.7.mix.project' + path;
    }

    var IPTokenEditorPane = BI.inherit(BI.Widget, {
        props: {
            baseCls: "iptoken-table",
            cType: "token",  // 可能有token或者ip两种
        },
        getValue: function () {
            return {
                userName: this.inputUserName.getValue(),
                params2: this.inputIPOrToken.getValue()
            }
        },
        render: function () {
            var that = this;
            var inputIPOrTokenText = "请输入ip：";
            if (this.options.cType === "token") {
                inputIPOrTokenText = "请输入token："
            }
            return {
                type: "bi.vtape",
                vgap: 10,
                height: 200,
                items: [
                    {
                        // https://fanruan.design/doc.html?post=2aff67999f#bi.horizontal_adapt
                        height: 20,
                        type: "bi.horizontal_adapt",
                        columnSize: [140, "fill"],
                        items: [{
                            type: "bi.label",
                            text: "输入用户名：",
                        }, {
                            type: "bi.text_editor",
                            watermark: "这个不允许为空",
                            allowBlank: false,
                            ref: function (e) {
                                that.inputUserName = e;
                            },
                            errorText: "非空!",
                        }]
                    },
                    {
                        height: 20,
                        type: "bi.horizontal_adapt",
                        columnSize: [140, "fill"],
                        items: [{
                            type: "bi.label",
                            text: inputIPOrTokenText,
                        }, {
                            type: "bi.text_editor",
                            watermark: "这个不允许为空",
                            allowBlank: false,
                            ref: function (e) {
                                that.inputIPOrToken = e;
                            },
                            errorText: "非空!",
                        }]
                    }
                ]
            }
        }
    });
    BI.shortcut("bi.add.userTokenOrIp", IPTokenEditorPane);
})();