package com.fr.plugin.component;

import com.fr.web.struct.AssembleComponent;
import com.fr.web.struct.Atom;
import com.fr.web.struct.Component;
import com.fr.web.struct.browser.RequestClient;
import com.fr.web.struct.category.ScriptPath;
import com.fr.web.struct.category.StylePath;

public class IPTokenComponent extends AssembleComponent {
    public static IPTokenComponent KEY = new IPTokenComponent();

    // 这里用私有构造函数避免外部实例化这个类，只能通过KEY这个单例引用
    private IPTokenComponent() {
    }

    @Override
    public Atom[] refer() {
        return new Atom[]{
                // 生成一个匿名Component 只实现script 返回我们依赖的script
                new Component() {
                    @Override
                    public ScriptPath script(RequestClient requestClient) {
                        return ScriptPath.build("com/fr/plugin/web/table.js");
                    }
                },
                // 生成一个匿名Component 只实现script 返回我们依赖的script
                new Component() {
                    @Override
                    public ScriptPath script(RequestClient requestClient) {
                        return ScriptPath.build("com/fr/plugin/web/userIpadd.js");
                    }
                },
                // 生成一个匿名Component 只实现script 返回我们依赖的script
                new Component() {
                    @Override
                    public ScriptPath script(RequestClient requestClient) {
                        return ScriptPath.build("com/fr/plugin/web/tokenConfig.js");
                    }
                }
        };
    }

    @Override
    public ScriptPath script(RequestClient requestClient) {

        return ScriptPath.build("com/fr/plugin/web/ipConfig.js");
    }

    @Override
    public StylePath style(RequestClient requestClient) {

        return StylePath.build("com/fr/plugin/web/iptoken.css");
    }
}
