package com.fr.plugin.entity;

import com.fr.stable.db.entity.BaseEntity;
import com.fr.third.javax.persistence.Column;
import com.fr.third.javax.persistence.Entity;
import com.fr.third.javax.persistence.Table;

// 第一步，增加这两个注解，特别是table的name属性要唯一，并将继承到BaseEntity，公自动产生id字段
@Entity
@Table(name = "plugin_user_ip_relationship")
public class UserIpEntity extends BaseEntity {
    // 第二步，注册要使用的字段加上@Column注解
    @Column(
            name = "userName",
            unique = true
    )
    private String userName;

    @Column(
            name = "ip",
            unique = true
    )
    private String ip;

    // 第三步，生成对应的get和set
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {

        this.userName = userName;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}
