package com.fr.plugin.filter;

import com.fr.decision.authority.data.User;
import com.fr.decision.fun.impl.AbstractGlobalRequestFilterProvider;
import com.fr.decision.webservice.utils.DecisionServiceConstants;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.plugin.IpTokenPluginDecisionDBAccessProvider;
import com.fr.plugin.dao.UserTokenRelationDao;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.restriction.RestrictionFactory;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class TokenGlobalRequestFilter extends AbstractGlobalRequestFilterProvider {
    @Override
    public String filterName() {
        return "iptoken";
    }

    @Override
    public String[] urlPatterns() {
        return new String[]{"/decision/*"};
    }

    /**
     * 本章目前只实现了token登录，在下一章我们实现ip拦截
     *
     * @param req
     * @param res
     * @param filterChain
     */
    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) {
        try {
            // 未登录才获取token，这里登录成功或失败都交给下一步去处理
            if (!isLogin(req)) {
                login(req, res);
            }
            filterChain.doFilter(req, res);
        } catch (IOException | ServletException ignored) {
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 具体登录的逻辑
     *
     * @param req
     * @param res
     * @throws Exception
     */
    private void login(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String my_token = req.getParameter("token");
        if (StringUtils.isNotBlank(my_token)) {
            String userName = getUserNameByToken(my_token);
            User user = UserService.getInstance().getUserByUserName(userName);
            if (user != null) {
                String loginToken = LoginService.getInstance().login(req, res, userName);
                req.setAttribute(DecisionServiceConstants.FINE_AUTH_TOKEN_NAME, loginToken);
            }
        }
    }

    private String getUserNameByToken(String token) throws Exception {
        // 获取数据库访问器
        DBAccessor dbAccessor = IpTokenPluginDecisionDBAccessProvider.getDbAccessor();
        // 通过dao查询数据库返回时的一个list
        List<UserTokenEntity> entities = dbAccessor.runQueryAction(daoContext ->
                daoContext.getDAO(UserTokenRelationDao.class).find(QueryFactory.create().addRestriction(RestrictionFactory.eq("token", token))));
        // 如果查询到有结果就返回第一个关联的用户
        if (!entities.isEmpty()) {
            return entities.get(0).getUserName();
        }
        return "";
    }

    private boolean isLogin(HttpServletRequest request) {
        return LoginService.getInstance().isLogged(request);
    }
}
