;(function () {
    var IpHeader = [[{
        text: "id",
    }, {
        text: "用户名",
    }, {
        text: "IP",
    }, {
        text: "操作"
    }]];

    var TokenHeader = [[{
        text: "id",
    }, {
        text: "用户名",
    }, {
        text: "Token",
    }, {
        text: "操作"
    }]];

    function resolvePath(path, isPublic) {
        if (!path || path[0] !== '/') {
            path = '/' + path;
        }
        return isPublic === true
            ? '/plugin/public/com.fr.plugin.7.mix.project' + path
            : '/plugin/private/com.fr.plugin.7.mix.project' + path;
    }

    var IPAndTokenTable = BI.inherit(BI.Widget, {
        props: {
            baseCls: "iptoken-table",
            cType: "ipTable"
        },
        beforeInit: function (render) {
            // 根据组件生命周期，在这个环境初始化组件需要的第一页数据
            var that = this;
            this.getData(function (data) {
                that.allData = data;
                render();
            })
        },
        getData: function (callback) {
            var that = this;
            var url = "/token/list";
            if (this.options.tableType === "ipTable") {
                url = "/ip/list"
            }
            // Dec.req下一共有GET,POST,PUT,DELETE，patch和后台RequestMethod对应
            Dec.reqGet(
                resolvePath(url, false)//第一个参数是要访问的地址
                , {}//第二个参数是请求参数
                , function (data) {//第三个参数是回调成功
                    var tempData = BI.map(data, function (i, v) {
                        return BI.map(v, function (ii, vv) {
                            return {
                                text: vv,
                                whiteSpace: "normal"
                            }
                        })
                    });
                    BI.each(tempData, function (i, v) {
                        v.push({
                            type: "bi.button",
                            text: "删除",
                            handler: function () {
                                var id = v[0].text;
                                var url = "/token/del";
                                if (that.options.tableType === "ipTable") {
                                    url = "/ip/del"
                                }
                                Dec.reqDelete(resolvePath(url, false), {
                                    id: id
                                }, function () {
                                    that.reload();
                                })
                            }
                        }, {
                            type: "bi.button",
                            text: "编辑",
                            handler: function () {
                                var tid = v[0].text;
                                var url = "/token/mod";
                                var headerText = "token";
                                var id = "modUserPane";
                                if (that.options.tableType === "ipTable") {
                                    url = "/ip/mod"
                                    headerText = "ip"
                                }
                                debugger
                                // 参考：https://fanruan.design/doc.html?post=df052e5842
                                BI.Popovers.create(id, {
                                    type: "bi.bar_popover",
                                    // String或者是json都行
                                    header: "编辑" + headerText + "限制",
                                    size: "small",
                                    body: {
                                        type: "bi.add.userTokenOrIp",
                                        cType: headerText,
                                        ref: function (e) {
                                            that.userIpPane = e;
                                        }
                                    },
                                    listeners: [{
                                        eventName: "EVENT_CANCEL",
                                        action: function () {
                                            BI.Msg.toast("点击了取消")
                                        }
                                    }, {
                                        eventName: "EVENT_CONFIRM",
                                        action: function () {
                                            var params = that.userIpPane.getValue();
                                            console.info(params)
                                            Dec.reqPut(resolvePath(url, false), {
                                                id: tid,
                                                userName: params.userName,
                                                params: params.params2
                                            }, function () {
                                                BI.Msg.toast("编辑成功")
                                                that.reload();
                                            })
                                        }
                                    }]
                                }).open(id);
                            }
                        })
                    });
                    callback(tempData);
                });
            //还有一个complete参数一共4个 00：26：37
        },
        reload: function () {
            var that = this;
            this.getData(function (data) {
                that.tableIns.populate(data)
            })
        },
        render: function () {
            var that = this;
            var header = TokenHeader;
            if (this.options.tableType === "ipTable") {
                header = IpHeader
            }
            return {
                // table_view https://fanruan.design/doc.html?post=5c39511444
                type: "bi.table_view",
                width: 600,
                height: 400,
                ref: function (e) {
                    that.tableIns = e;
                },
                minColumnSize: [100, 100, 100],
                columnSize: [100, 100, 100],
                regionColumnSize: [300, "fill"],
                items: this.allData,
                header: header,
            }
        }
    });
    BI.shortcut("dec.management.iptoken.table", IPAndTokenTable);
})();