;(function () {
    // 关联wiki：https://wiki.fanruan.com/pages/viewpage.action?pageId=20021612
    // 特别注意，此配置需要配合服务器SystemOptionProvider接口使用，不然会因无权限而不显示节点
    BI.config("dec.constant.management.navigation", function (items) {
        items.push({
            value: "iptoken",  // 地址栏显示的hash值
            id: "ipToken-1",  // id这个要和java写的 IpTokenOptionProvider 的id对应
            text: BI.i18nText("Token关系配置"),  // 文字
            cardType: "dec.management.tokenConfig",  // 组件的shortcut,适用于用fineui开发的页面.
            cls: "management-directory-font"  // 图标类名
        });
        return items;
    });

    // 这个是从系统自己实现的中拷贝出来的，进行了一点修改
    function resolvePath(path, isPublic) {
        if (!path || path[0] !== '/') {
            path = '/' + path;
        }
        return isPublic === true
            ? '/plugin/public/com.fr.plugin.7.mix.project' + path
            : '/plugin/private/com.fr.plugin.7.mix.project' + path;
    }

    // 组件实现，效果为使用绝对布局组件放置了一个iframe
    var tokenConfig = BI.inherit(BI.Widget, {
        props: {
            baseCls: "tokenConfig"
        },
        render: function () {
            var self = this;
            return {
                type: "bi.absolute",
                items: [
                    {
                        el: {
                            type: "bi.button",
                            text: "添加",
                            handler: function () {
                                var id = "addUserPane"
                                var that = this;
                                // 参考：https://fanruan.design/doc.html?post=df052e5842
                                BI.Popovers.create(id, {
                                    type: "bi.bar_popover",
                                    // String或者是json都行
                                    header: "添加用户Token关联",
                                    size: "small",
                                    body: {
                                        type: "bi.add.userTokenOrIp",
                                        cType: "token",
                                        ref: function (e) {
                                            that.userIpPane = e;
                                        }
                                    },
                                    listeners: [{
                                        eventName: "EVENT_CANCEL",
                                        action: function () {
                                            // $("#xxxx").on("click",function (){
                                            //
                                            // })
                                            BI.Msg.toast("点击了取消")
                                        }
                                    }, {
                                        eventName: "EVENT_CONFIRM",
                                        action: function () {
                                            var params=that.userIpPane.getValue();
                                            console.info(params)
                                            Dec.reqPost(resolvePath("/token/add",false),{
                                                userName:params.userName,
                                                token:params.params2
                                            },function (){
                                                BI.Msg.toast("保存成功")
                                                self.tableRef.reload();
                                            })
                                        }
                                    }]
                                }).open(id);
                            }
                        },
                        top: 0,
                        left: 0
                    },
                    {
                        el: {
                            type: "bi.button",
                            text: "刷新",
                            handler: function () {
                                self.tableRef.reload();
                            }
                        },
                        top: 0,
                        left: 100
                    },
                    {
                        el: {
                            type: "dec.management.iptoken.table",
                            tableType: "tokenTable",
                            ref: function (e) {
                                self.tableRef = e;
                            }
                        },
                        top: 40,
                        left: 0,
                        right: 0,
                        bottom: 0
                    }
                ]
            };
        }
    });
    BI.shortcut("dec.management.tokenConfig", tokenConfig);
})();
