package com.fr.plugin;

import com.fr.decision.plugin.db.AbstractDecisionDBAccessProvider;
import com.fr.plugin.dao.UserIpRelationDao;
import com.fr.plugin.dao.UserTokenRelationDao;
import com.fr.plugin.entity.UserIpEntity;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.plugin.transform.ExecuteFunctionRecord;
import com.fr.plugin.transform.FunctionRecorder;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.db.dao.BaseDAO;
import com.fr.stable.db.dao.DAOProvider;

// 第一步，类继承AbstractDecisionDBAccessProvider
@FunctionRecorder
public class IpTokenPluginDecisionDBAccessProvider extends AbstractDecisionDBAccessProvider {
    // 第二步，注册数据库访问类 DBAccessible
    @Override
    @ExecuteFunctionRecord
    public DAOProvider[] registerDAO() {
        return new DAOProvider[]{
                // 注意这里是匿名类
                new DAOProvider() {
                    @Override
                    public Class getEntityClass() {
                        return UserTokenEntity.class;
                    }

                    @Override
                    public Class<? extends BaseDAO> getDAOClass() {
                        return UserTokenRelationDao.class;
                    }
                },
                new DAOProvider() {
                    @Override
                    public Class getEntityClass() {
                        return UserIpEntity.class;
                    }

                    @Override
                    public Class<? extends BaseDAO> getDAOClass() {
                        return UserIpRelationDao.class;
                    }
                }
        };
    }

    // 第三步，新建一个DBAccessor 静态变量
    private static DBAccessor dbAccessor = null;

    // 第四步，写一个公开的静态方法去获取DBAccessor
    public static DBAccessor getDbAccessor() {
        return dbAccessor;
    }

    // 第五步，重写数据库访问器注入函数（当数据库访问器准备好了之后由fr注入到这里）
    // DBAccessible DBInjectable
    @Override
    public void onDBAvailable(DBAccessor dbAccessor) {
        IpTokenPluginDecisionDBAccessProvider.dbAccessor = dbAccessor;
    }
}
