package com.fr.plugin.filter;

import com.fr.decision.fun.impl.AbstractGlobalRequestFilterProvider;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.plugin.IpTokenPluginDecisionDBAccessProvider;
import com.fr.plugin.dao.UserIpRelationDao;
import com.fr.plugin.entity.UserIpEntity;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.web.utils.WebUtils;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class IpGlobalRequestFilter extends AbstractGlobalRequestFilterProvider {
    @Override
    public String filterName() {
        return "iptoken";
    }

    @Override
    public String[] urlPatterns() {
        return new String[]{
                "/decision/*"
        };
    }

    /**
     * @param req
     * @param res
     * @param filterChain
     */
    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) {
        try {
            // 未登录才获取token，这里登录成功或失败都交给下一步去处理
            if (isLogin(req)) {
                // 使用loginService 获取当前登录的用户名
                String currentUserName = LoginService.getInstance().getCurrentUserNameFromRequestCookie(req);
                String currentUserId = UserService.getInstance().getCurrentUserId(currentUserName);
                if (!UserService.getInstance().isAdmin(currentUserId)) {
                    String ip = getIp(req);
                    if (!checkUserCanLoginOnIp(currentUserName, ip)) {
                        WebUtils.printAsString(res, "对不起，您不能在" + ip + "登录！");
                        return;
                    }
                }
            }
            filterChain.doFilter(req, res);
        } catch (IOException | ServletException ignored) {
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getIp(HttpServletRequest req) {
        // 这里忽略有前置代理服务器的情况，默认就是直接访问的
        return req.getRemoteAddr();
    }

    /**
     * 检查用户是否有权限在这个ip上登录
     * @param userName
     * @param ip
     * @return
     * @throws Exception
     */
    private boolean checkUserCanLoginOnIp(String userName, String ip) throws Exception {
        // 获取访问器
        DBAccessor dbAccessor = IpTokenPluginDecisionDBAccessProvider.getDbAccessor();
        // 通过dao查询数据库返回时的一个list
        List<UserIpEntity> entities = dbAccessor.runQueryAction(daoContext ->
                daoContext.getDAO(UserIpRelationDao.class)
                        .find(
                                QueryFactory.create()
                                        .addRestriction(RestrictionFactory.eq("userName", userName))
                                        .addRestriction(RestrictionFactory.eq("ip", ip))
                        ));
        // 如果查询到有对应权限就直接返回允许登录
        return !entities.isEmpty();
    }

    private boolean isLogin(HttpServletRequest request) {
        return LoginService.getInstance().isLogged(request);
    }
}
