package com.fr.plugin.http.ip;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.IpTokenPluginDecisionDBAccessProvider;
import com.fr.plugin.dao.UserIpRelationDao;
import com.fr.plugin.entity.UserIpEntity;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;

public class DelApi extends BaseHttpHandler {
    @Override
    public RequestMethod getMethod() {
        // 表格里的删除按钮是DELETE
        return RequestMethod.DELETE;
    }

    @Override
    public String getPath() {
        return "/ip/del";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DBAccessor dbAccessor = IpTokenPluginDecisionDBAccessProvider.getDbAccessor();
        // 通过这两个函数获取的参数可以避免中文乱码和空指针
//        String userName = WebUtils.getHTTPRequestParameter(httpServletRequest, "userName");
//        String ip = WebUtils.getHTTPRequestParameter(httpServletRequest, "ip");
        String body = getBody(httpServletRequest);
        JSONObject entries = new JSONObject(body);

        //表格外delete button用
//        String userName = entries.getString("userName");
//        String ip = entries.getString("ip");
//        if (StringUtils.isBlank(userName) || StringUtils.isBlank(ip)) {
//            JSONObject jsonObject = new JSONObject();
//            jsonObject.put("msg", "user name or ip is blank");
//            jsonObject.put("code", -1);
//            WebUtils.printAsJSON(httpServletResponse, jsonObject);
//        }
        String id = entries.getString("id");

        QueryCondition queryCondition = QueryFactory.create();
        // 先查找要删除的用户
        List<UserIpEntity> entityList = dbAccessor.runQueryAction(daoContext -> {
            //表格外delete button用
//            if (StringUtils.isNotBlank(userName) && StringUtils.isNotBlank(ip)) {
//                queryCondition.addRestriction(RestrictionFactory.and(
//                        RestrictionFactory.eq("userName", userName), RestrictionFactory.eq("ip", ip)));
//            }else if(StringUtils.isNotBlank(userName) && StringUtils.isEmpty(ip)){
//                queryCondition.addRestriction(RestrictionFactory.eq("userName", userName));
//            }
            if (StringUtils.isNotBlank(id)) {
                queryCondition.addRestriction(RestrictionFactory.eq("id", id));
            }
            List<UserIpEntity> entityList1 = daoContext.getDAO(UserIpRelationDao.class).find(queryCondition);
            return entityList1;
        });

        if (entityList.size() > 0) {
            dbAccessor.runDMLAction(daoContext -> {
                // 执行删除操作
                daoContext.getDAO(UserIpRelationDao.class).remove(queryCondition);
                return null;
            });
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "success");
            jsonObject.put("code", 200);
            WebUtils.printAsJSON(httpServletResponse, jsonObject);
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "remove failture");
            jsonObject.put("code", -1);
            WebUtils.printAsJSON(httpServletResponse, jsonObject);
        }
    }

    String getBody(HttpServletRequest request) throws IOException {
        BufferedReader br = request.getReader();
        String str;
        StringBuilder wholeStr = new StringBuilder();
        while ((str = br.readLine()) != null) {
            wholeStr.append(str);
        }
        return wholeStr.toString();
    }
}
