package com.fr.plugin.http.token;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.IpTokenPluginDecisionDBAccessProvider;
import com.fr.plugin.dao.UserTokenRelationDao;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;

public class TokenDelApi extends BaseHttpHandler {
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.DELETE;
    }

    @Override
    public String getPath() {
        return "/token/del";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DBAccessor dbAccessor = IpTokenPluginDecisionDBAccessProvider.getDbAccessor();
        // 通过这两个函数获取的参数可以避免中文乱码和空指针
//        String userName = WebUtils.getHTTPRequestParameter(httpServletRequest, "userName");
        String body = getBody(httpServletRequest);
        JSONObject entries = new JSONObject(body);

        String id = entries.getString("id");

        QueryCondition queryCondition = QueryFactory.create();
        // 先查找要删除的用户
        List<UserTokenEntity> entityList = dbAccessor.runQueryAction(daoContext -> {
            if (StringUtils.isNotBlank(id)) {
                queryCondition.addRestriction(RestrictionFactory.eq("id", id));
            }
            List<UserTokenEntity> entityList1 = daoContext.getDAO(UserTokenRelationDao.class).find(queryCondition);
            return entityList1;
        });

        if (entityList.size() > 0) {
            dbAccessor.runDMLAction(daoContext -> {
                // 执行删除操作
                daoContext.getDAO(UserTokenRelationDao.class).remove(queryCondition);
                return null;
            });
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "success");
            jsonObject.put("code", 200);
            WebUtils.printAsJSON(httpServletResponse, jsonObject);
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "remove failture");
            jsonObject.put("code", -1);
            WebUtils.printAsJSON(httpServletResponse, jsonObject);
        }
    }

    String getBody(HttpServletRequest request) throws IOException {
        BufferedReader br = request.getReader();
        String str;
        StringBuilder wholeStr = new StringBuilder();
        while ((str = br.readLine()) != null) {
            wholeStr.append(str);
        }
        return wholeStr.toString();
    }
}
