package com.fr.plugin.http.token;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.IpTokenPluginDecisionDBAccessProvider;
import com.fr.plugin.dao.UserTokenRelationDao;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;

public class TokenModApi extends BaseHttpHandler {
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }

    @Override
    public String getPath() {
        return "/token/mod";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse)
            throws Exception {
        DBAccessor dbAccessor = IpTokenPluginDecisionDBAccessProvider.getDbAccessor();

        // 通过这两个函数获取的参数可以避免中文乱码和空指针
//        String userName = WebUtils.getHTTPRequestParameter(httpServletRequest, "userName");
//        String token = WebUtils.getHTTPRequestParameter(httpServletRequest, "token");

        String body = getBody(httpServletRequest);
        JSONObject entries = new JSONObject(body);
        QueryCondition queryCondition = QueryFactory.create();

        String id = entries.getString("id");
        String userName = entries.getString("userName");
        String token = entries.getString("params");

        // 先查找要更新的用户
        UserTokenEntity entity = dbAccessor.runQueryAction(daoContext -> daoContext.getDAO(UserTokenRelationDao.class)
                .findOne(QueryFactory.create().addRestriction(RestrictionFactory.eq("id", id)))
        );
        if (entity != null) {
            entity.setUserName(userName);
            entity.setToken(token);
            dbAccessor.runDMLAction(daoContext -> {
                // 更新执行操作
                daoContext.getDAO(UserTokenRelationDao.class).update(entity);
                return null;
            });
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "success");
            jsonObject.put("code", 200);
            WebUtils.printAsJSON(httpServletResponse, jsonObject);
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "user not find");
            jsonObject.put("code", -1);
            WebUtils.printAsJSON(httpServletResponse, jsonObject);
        }
    }

    String getBody(HttpServletRequest request) throws IOException {
        BufferedReader br = request.getReader();
        String str;
        StringBuilder wholeStr = new StringBuilder();
        while ((str = br.readLine()) != null) {
            wholeStr.append(str);
        }
        return wholeStr.toString();
    }
}
