package com.fr.plugin.http.API;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.MyDecisionDBAccessProvider;
import com.fr.plugin.dao.MyDao_IPRange;
import com.fr.plugin.dao.MyDao_UserToken;
import com.fr.plugin.entity.MyIPRange;
import com.fr.plugin.entity.MyUserToken;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.third.jgroups.util.UUID;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class API_ADD extends BaseHttpHandler{
    @Override
    public RequestMethod getMethod()
    {
        return null;
    }

    @Override
    public String getPath()
    {
        return "/API_ADD";
    }

    @Override
    public boolean isPublic()
    {
        return true;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws Exception
    {
        DBAccessor dbAccessor = MyDecisionDBAccessProvider.getDbAccessor();
        String s = new MyGetBody().getBody(req);
        JSONObject APIJson = new JSONObject(s);

        String userName = APIJson.getString("userName");
        String userToken = APIJson.getString("userToken");
        String IPAddress = APIJson.getString("IPAddress");

        if(!StringUtils.isNotBlank(userName))
        {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","add fail, userName Cannot be empty!");
            jsonObject.put("code",100);
            WebUtils.printAsJSON(res, jsonObject);
            return;
        }

        if(!StringUtils.isNotBlank(userToken))
        {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","add fail, userToken Cannot be empty!");
            jsonObject.put("code",101);
            WebUtils.printAsJSON(res, jsonObject);
            return;
        }

        String id = UUID.randomUUID().toString();

        MyUserToken myUserToken = new MyUserToken();
        myUserToken.setId(id);
        myUserToken.setUserName(userName);
        myUserToken.setUserToken(userToken);


        MyIPRange myIPRange = new MyIPRange();
        myIPRange.setId(id);
        myIPRange.setIPAddress(IPAddress);


        try
        {
            dbAccessor.runDMLAction(
                    daoContext ->
                    {
                        daoContext.getDAO(MyDao_UserToken.class).add(myUserToken);
                        if(StringUtils.isNotBlank(IPAddress))
                        {
                            daoContext.getDAO(MyDao_IPRange.class).add(myIPRange);
                        }
                        return null;
                    });
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "\"" + userName + "\" 已添加~~~");
            jsonObject.put("code",200);
            WebUtils.printAsJSON(res, jsonObject);
        }catch (Exception e)
        {
            e.printStackTrace();
            WebUtils.printAsString(res, e.getCause().getMessage().split(";")[0]);
        }
    }
}
