package com.fr.plugin.http;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONArray;
import com.fr.plugin.MyDecisionDBAccessProvider;
import com.fr.plugin.dao.MyDao_UserToken;
import com.fr.plugin.entity.MyUserToken;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

public class Data_Sel extends BaseHttpHandler
{
    @Override
    public RequestMethod getMethod()
    {
        return null;
    }

    @Override
    public String getPath()
    {
        return "/DBAccess_Sel";
    }

    @Override
    public boolean isPublic()
    {
        return true;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws Exception
    {
        DBAccessor dbAccessor = MyDecisionDBAccessProvider.getDbAccessor();
        String userToken = req.getParameter("userToken");
        List<MyUserToken> entityList = dbAccessor.runQueryAction(daoContext ->
        {
            QueryCondition queryCondition = QueryFactory.create();
            //满足条件时给出对应数据，不满足时返回全部数据
            if(StringUtils.isNotBlank(userToken))
            {
                queryCondition.addRestriction(RestrictionFactory.eq("userToken", userToken));
            }
            return daoContext.getDAO(MyDao_UserToken.class).find(queryCondition);
        });
        JSONArray jsonArray = JSONArray.create(entityList);
        WebUtils.printAsJSON(res,jsonArray);
        // WebUtils.printAsString(res, String.valueOf(entityList.size()));
    }
}
