package com.fr.plugin;

import com.fr.plugin.transform.ExecuteFunctionRecord;
import com.fr.plugin.transform.FunctionRecorder;
import com.fr.web.struct.Component;
import com.fr.web.struct.Filter;
import com.fr.web.struct.browser.RequestClient;
import com.fr.web.struct.category.ScriptPath;
import com.fr.web.struct.category.StylePath;

@FunctionRecorder
public class MyComponent extends Component {
    public static final MyComponent KEY = new MyComponent();
    private MyComponent(){}
    /**
     * 返回需要引入的JS脚本路径
     * @param client 请求客户端描述
     * @return JS脚本路径
     */
    public ScriptPath script( RequestClient client ) {
        //如果不需要就直接返回  ScriptPath.EMPTY
        return ScriptPath.build("com/fr/plugin/web/MyComponent.js");
    }

    /**
     * 返回需要引入的CSS样式路径
     * @param client 请求客户端描述
     * @return CSS样式路径
     */
    public StylePath style( RequestClient client ) {
        //如果不需要就直接返回 StylePath.EMPTY;
        return StylePath.build("com/fr/plugin/web/MyComponent.css");
    }

    /**
     * 通过给定的资源过滤器控制是否加载这个资源
     * @return 资源过滤器
     */
    @ExecuteFunctionRecord
    public Filter filter() {
        return new Filter(){
            @Override
            public boolean accept() {
                //任何情况下我们都在平台组件加载时加载我们的组件
                return true;
            }
        };
    }
}