package com.fr.plugin;

import com.fr.decision.plugin.db.AbstractDecisionDBAccessProvider;
import com.fr.plugin.dao.MyDao_IPRange;
import com.fr.plugin.dao.MyDao_UserToken;
import com.fr.plugin.entity.MyIPRange;
import com.fr.plugin.entity.MyUserToken;
import com.fr.plugin.transform.ExecuteFunctionRecord;
import com.fr.plugin.transform.FunctionRecorder;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.db.dao.BaseDAO;
import com.fr.stable.db.dao.DAOProvider;

@FunctionRecorder
public class MyDecisionDBAccessProvider extends AbstractDecisionDBAccessProvider
{
    @Override
    @ExecuteFunctionRecord
    public DAOProvider[] registerDAO()
    {
        return new DAOProvider[]
                {
                        new DAOProvider()
                        {
                            @Override
                            public Class getEntityClass()
                            {
                                return MyIPRange.class;
                            }

                            @Override
                            public Class<? extends BaseDAO> getDAOClass()
                            {
                                return MyDao_IPRange.class;
                            }
                        },
                        new DAOProvider()
                        {
                            @Override
                            public Class getEntityClass()
                            {
                                return MyUserToken.class;
                            }

                            @Override
                            public Class<? extends BaseDAO> getDAOClass()
                            {
                                return MyDao_UserToken.class;
                            }
                        }
                };
    }

    private static DBAccessor dbAccessor = null;

    public static DBAccessor getDbAccessor()
    {
        return dbAccessor;
    }

    @Override
    public void onDBAvailable(DBAccessor dbAccessor)
    {
        MyDecisionDBAccessProvider.dbAccessor = dbAccessor;
    }
}
