package com.fr.plugin.http;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.MyDecisionDBAccessProvider;
import com.fr.plugin.dao.MyDao_IPRange;
import com.fr.plugin.dao.MyDao_UserToken;
import com.fr.plugin.entity.MyIPRange;
import com.fr.plugin.entity.MyUserToken;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.jgroups.util.UUID;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

public class Data_Add extends BaseHttpHandler
{
    @Override
    public RequestMethod getMethod()
    {
        return null;
    }

    @Override
    public String getPath()
    {
        return "/DBAccess_Add";
    }

    @Override
    public boolean isPublic()
    {
        return true;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws Exception
    {
        DBAccessor dbAccessor = MyDecisionDBAccessProvider.getDbAccessor();
        String userName = WebUtils.getHTTPRequestParameter(req,"userName");
        String userToken = WebUtils.getHTTPRequestParameter(req,"userToken");
        String IPAddress = WebUtils.getHTTPRequestParameter(req,"IPAddress");

        if((!StringUtils.isNotBlank(userName) && !StringUtils.isNotBlank(userToken))
                || (StringUtils.isNotBlank(IPAddress) && !StringUtils.isNotBlank(userName)))
        {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","add fail, userName or userToken Cannot be empty!");
            jsonObject.put("code",100);
            WebUtils.printAsJSON(res, jsonObject);
            return;
        }

        List<MyUserToken> entityList = dbAccessor.runQueryAction(daoContext ->
        {
            QueryCondition queryCondition = QueryFactory.create();
            queryCondition.addRestriction(RestrictionFactory.or(
                        RestrictionFactory.eq("userName", userName),
                        RestrictionFactory.eq("userToken", userToken)));
            return daoContext.getDAO(MyDao_UserToken.class).find(queryCondition);
        });

        String id = UUID.randomUUID().toString();

        if (entityList.size() > 0)
        {
            id = entityList.get(0).getId();
        }

        MyUserToken myUserToken = new MyUserToken();
        myUserToken.setId(id);
        myUserToken.setUserName(userName);
        myUserToken.setUserToken(userToken);

        MyIPRange myIPRange = new MyIPRange();
        myIPRange.setId(id);
        myIPRange.setIPAddress(IPAddress);

        try
        {
            dbAccessor.runDMLAction(
                    daoContext ->
                    {
                        if(entityList.size() == 0)
                        {
                            daoContext.getDAO(MyDao_UserToken.class).add(myUserToken);
                        }
                        if(StringUtils.isNotBlank(IPAddress))
                        {
                            daoContext.getDAO(MyDao_IPRange.class).add(myIPRange);
                        }
                        return null;
                    });
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "\"" + userName + "\" 已添加~~~");
            jsonObject.put("code",200);
            WebUtils.printAsJSON(res, jsonObject);
        }catch (Exception e)
        {
            e.printStackTrace();
            WebUtils.printAsString(res, e.getCause().getMessage().split(";")[0]);
        }
    }
}
