package com.fr.plugin;

import com.fr.decision.authority.data.User;
import com.fr.decision.fun.impl.AbstractGlobalRequestFilterProvider;
import com.fr.decision.webservice.utils.DecisionServiceConstants;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.general.ComparatorUtils;
import com.fr.log.FineLoggerFactory;
import com.fr.plugin.dao.MyDao_UserToken;
import com.fr.plugin.entity.MyUserToken;
import com.fr.plugin.transform.FunctionRecorder;
import com.fr.security.JwtUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.fun.Authorize;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.web.utils.WebUtils;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Authorize(callSignKey = MyFunctionConstants.PLUGIN_ID)
@FunctionRecorder
public class MyGlobalRequestFilter extends AbstractGlobalRequestFilterProvider
{
    @Override
    public String filterName()
    {
        return "login_test1";  //多个时，会按名称顺序序执行，理论上是这样，还没测试
    }

    @Override
    public String[] urlPatterns()
    {
        return new String[]{"/decision/*"};
    }

    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain fc)
    {
        String login_token = req.getParameter("login_token");

        //获取客户端IP
        String LocalIPAddress = req.getLocalAddr();

        try
        {
            if (StringUtils.isNotBlank(login_token))
            {
                //login_token不为空时查询数据库表，检查是否有相应userToken
                DBAccessor dbAccessor = MyDecisionDBAccessProvider.getDbAccessor();
                List<MyUserToken> myUserTokenList = dbAccessor.runQueryAction(daoContext ->
                {
                    QueryCondition queryCondition = QueryFactory.create();
                    //满足条件时给出对应数据，不满足时返回全部数据
                    if(StringUtils.isNotBlank(login_token))
                    {
                        queryCondition.addRestriction(RestrictionFactory.eq("userToken", login_token));
                    }
                    return daoContext.getDAO(MyDao_UserToken.class).find(queryCondition);
                });

                if (myUserTokenList.size() > 0)//判断上一步是否返回数据
                {
                    String username = myUserTokenList.get(0).getUserName(); //取得用户

                    if(isNeedLogin(username, req, res))
                    {
                        if(!LoginFR(username, req, res))
                        {
                            FineLoggerFactory.getLogger().error("登陆失败: 请联系管理员~~~");
                            WebUtils.printAsString(res, "登陆出错~");
                        }
                    }
                }
                else
                {
                    FineLoggerFactory.getLogger().error("用户账户不存在~~~");
                    WebUtils.printAsString(res, "用户账户不存在~~~");
                }
            }
            fc.doFilter(req,res);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            FineLoggerFactory.getLogger().error("登陆失败: 请联系管理员~~~");
        }
    }

    /**
     * 校验token是否有效
     */
    private boolean checkTokenValid(HttpServletRequest req, String token, String currentUserName)
    {
        try
        {
            //当前登录用户和token对应的用户名不同，需要重新生成token
            if (!ComparatorUtils.equals(currentUserName, JwtUtils.parseJWT(token).getSubject()))
            {
                FineLoggerFactory.getLogger().info("username changed：" + currentUserName);
                return false;
            }

            return LoginService.getInstance().isLogged(req);
        } catch (Exception ignore)
        {
        }
        return false;
    }

    private boolean isNeedLogin(String username, HttpServletRequest req, HttpServletResponse res)
    {
        try
        {
            String token = LoginService.getInstance().login(req, res, username);
            if(!checkTokenValid(req, token, username))
            {
                return  true;
            }
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        String frUser=LoginService.getInstance().getCurrentUserNameFromRequestCookie(req);
        return !ComparatorUtils.equals(username,frUser);
    }

    private boolean LoginFR(String username, HttpServletRequest req, HttpServletResponse res)
    {
        try{
            User user = UserService.getInstance().getUserByUserName(username);
            if (user == null)
            {
                WebUtils.printAsString(res,"登陆失败，用户 " + username + " 不存在~");
                return  false;
            }
            String token = LoginService.getInstance().login(req, res, username);
            req.setAttribute(DecisionServiceConstants.FINE_AUTH_TOKEN_NAME, token);
            return  true;
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        return  false;
    }
}
