package com.fr.plugin.http.API;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.MyDecisionDBAccessProvider;
import com.fr.plugin.dao.MyDao_IPRange;
import com.fr.plugin.dao.MyDao_UserToken;
import com.fr.plugin.entity.MyUserToken;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.condition.impl.QueryConditionImpl;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

public class API_DEL extends BaseHttpHandler
{
    @Override
    public RequestMethod getMethod()
    {
        return null;
    }

    @Override
    public String getPath()
    {
        return "/API_DEL";
    }

    @Override
    public boolean isPublic()
    {
        return true;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws Exception
    {
        DBAccessor dbAccessor = MyDecisionDBAccessProvider.getDbAccessor();
        String s = new MyGetBody().getBody(req);
        JSONObject APIJson = new JSONObject(s);

        String userName = APIJson.getString("userName");
        String userToken = APIJson.getString("userToken");
        String ipRangeID;

        //查询PK_ORG
        List<MyUserToken> userTokenList = dbAccessor.runQueryAction(daoContext ->
        {
            QueryCondition queryCondition = QueryFactory.create();
            if(StringUtils.isNotBlank(userToken))
            {
                queryCondition.addRestriction(RestrictionFactory.or(
                        RestrictionFactory.eq("userToken", userToken),
                        RestrictionFactory.eq("userName", userName)));
            }
            return daoContext.getDAO(MyDao_UserToken.class).find(queryCondition);
        });

        //获取List大小，不为0继续删除
        int i = userTokenList.size();
        //WebUtils.printAsString(res, "匹配到：" + i + " 行数据！");
        if(i == 0)
        {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","Not exist userToken = " + userToken);
            jsonObject.put("code",102);
            WebUtils.printAsJSON(res, jsonObject);
            return;
        }
        else
        {
            ipRangeID = userTokenList.get(0).getId();
        }

        //执行删除
        try
        {
            dbAccessor.runDMLAction(
                    daoContext ->
                    {
                        daoContext.getDAO(MyDao_UserToken.class).remove(new QueryConditionImpl().addRestriction(RestrictionFactory.or(
                                RestrictionFactory.eq("userToken", userToken),
                                RestrictionFactory.eq("userName",userName))));
                        if(StringUtils.isNotBlank(ipRangeID))
                        {
                            daoContext.getDAO(MyDao_IPRange.class).remove(new QueryConditionImpl().addRestriction(RestrictionFactory.eq("id", ipRangeID)));
                        }
                        return null;
                    });
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","已删除~~~\"" + userToken + "\"");
            jsonObject.put("code",300);
            WebUtils.printAsJSON(res, jsonObject);
        } catch (Exception e)
        {
            e.printStackTrace();
            WebUtils.printAsString(res, e.getCause().getMessage().split(";")[0]);
        }
    }
}
