package com.fr.plugin.http.API;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.MyDecisionDBAccessProvider;
import com.fr.plugin.dao.MyDao_IPRange;
import com.fr.plugin.dao.MyDao_UserToken;
import com.fr.plugin.entity.MyIPRange;
import com.fr.plugin.entity.MyUserToken;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.jgroups.util.UUID;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;

public class API_UPD extends BaseHttpHandler
{
    @Override
    public RequestMethod getMethod()
    {
        return null;
    }

    @Override
    public String getPath()
    {
        return "/API_UPD";
    }

    @Override
    public boolean isPublic()
    {
        return true;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws Exception
    {
        DBAccessor dbAccessor = MyDecisionDBAccessProvider.getDbAccessor();
        String s = new MyGetBody().getBody(req);
        JSONObject APIJson = new JSONObject(s);

        String userName = APIJson.getString("userName");
        String userToken = APIJson.getString("userToken");
        String IPAddress = APIJson.getString("IPAddress");
        String ipAddressID = "";

        if(!StringUtils.isNotBlank(userName))
        {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","add/update userName fail, userName Cannot be empty!");
            jsonObject.put("code",104);
            WebUtils.printAsJSON(res, jsonObject);
            return;
        }

        if(!StringUtils.isNotBlank(userToken))
        {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","add/update userToken fail, userToken Cannot be empty!");
            jsonObject.put("code",105);
            WebUtils.printAsJSON(res, jsonObject);
            return;
        }

        if(!StringUtils.isNotBlank(IPAddress))
        {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg","add/update IPAddress fail, IPAddress Cannot be empty!");
            jsonObject.put("code",105);
            WebUtils.printAsJSON(res, jsonObject);
            return;
        }

        MyUserToken myUserToken_0 = dbAccessor.runQueryAction(daoContext -> daoContext.getDAO(MyDao_UserToken.class).
                findOne(QueryFactory.create().addRestriction(RestrictionFactory.or(
                        RestrictionFactory.eq("userName",userName),
                        RestrictionFactory.eq("userToken",userToken)))));
        MyUserToken myUserToken_1 = new MyUserToken();

        MyIPRange myIPRange_0 = dbAccessor.runQueryAction(daoContext -> daoContext.getDAO(MyDao_IPRange.class).
                findOne(QueryFactory.create().addRestriction(RestrictionFactory.eq("id",ipAddressID))));
        MyIPRange myIPRange_1 = new MyIPRange();

        if(myUserToken_0 == null)
        {
            String pkID = UUID.randomUUID().toString();
            myUserToken_1.setId(pkID);
            myUserToken_1.setUserName(userName);
            myUserToken_1.setUserToken(userToken);

            myIPRange_1.setId(pkID);
            myIPRange_1.setIPAddress(IPAddress);
        }
        else
        {
            myUserToken_0.setUserName(userName);
            myUserToken_0.setUserToken(userToken);

            myIPRange_0.setIPAddress(IPAddress);
        }

        try
        {
            dbAccessor.runDMLAction(
                    daoContext ->
                    {
                        if(myUserToken_0 != null)
                        {
                            daoContext.getDAO(MyDao_UserToken.class).update(myUserToken_0);  //更新
                            daoContext.getDAO(MyDao_IPRange.class).update(myIPRange_0);
                        }
                        else
                        {
                            daoContext.getDAO(MyDao_UserToken.class).addOrUpdate(myUserToken_1); //更新或添加
                            daoContext.getDAO(MyDao_IPRange.class).addOrUpdate(myIPRange_1);
                        }
                        return null;
                    });
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "已更新/添加~~~ \"" + userName + "\"");
            jsonObject.put("code",200);
            WebUtils.printAsJSON(res, jsonObject);
        }catch (Exception e)
        {
            e.printStackTrace();
            WebUtils.printAsString(res, e.getCause().getMessage().split(";")[0]);
        }
    }
}

