package com.fr.plugin;

import com.fr.decision.plugin.db.AbstractDecisionDBAccessProvider;
import com.fr.plugin.dao.UserIpDao;
import com.fr.plugin.dao.UserTokenDao;
import com.fr.plugin.entity.UserIpEntity;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.plugin.transform.ExecuteFunctionRecord;
import com.fr.plugin.transform.FunctionRecorder;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.db.dao.BaseDAO;
import com.fr.stable.db.dao.DAOProvider;

@FunctionRecorder
public class IpTokenDecisionDBAccessProvider extends AbstractDecisionDBAccessProvider {
    @Override
    @ExecuteFunctionRecord
    public DAOProvider[] registerDAO() {
        return new DAOProvider[]{
                new DAOProvider() {
                    @Override
                    public Class getEntityClass() {
                        return UserIpEntity.class;
                    }

                    @Override
                    public Class<? extends BaseDAO> getDAOClass() {
                        return UserIpDao.class;
                    }
                }
                //
                ,new DAOProvider() {
                    @Override
                    public Class getEntityClass() {
                        return UserTokenEntity.class;
                    }

                    @Override
                    public Class<? extends BaseDAO> getDAOClass() {
                        return UserTokenDao.class;
            }
                }
        };
    }

    private static DBAccessor dbAccessor = null;

    public static DBAccessor getDbAccessor(){
        return dbAccessor;
    }

    @Override
    public void onDBAvailable(DBAccessor dbAccessor) {
        IpTokenDecisionDBAccessProvider.dbAccessor = dbAccessor;
    }
}
