package com.fr.plugin.components;

import com.fr.web.struct.AssembleComponent;
import com.fr.web.struct.Atom;
import com.fr.web.struct.Component;
import com.fr.web.struct.browser.RequestClient;
import com.fr.web.struct.category.ScriptPath;
import com.fr.web.struct.category.StylePath;

public class IpTokenComponent extends AssembleComponent {

    public static IpTokenComponent KEY = new IpTokenComponent();

    private IpTokenComponent(){
    }

    @Override
    public Atom[] refer() {
        return new Atom[]{
                new Component() {
                    @Override
                    public ScriptPath script(RequestClient requestClient) {
                        return ScriptPath.build("com/fr/plugin/web/table.js");
                    }
                },
                new Component() {
                    @Override
                    public ScriptPath script(RequestClient requestClient) {
                        return ScriptPath.build("com/fr/plugin/web/userIpAdd.js");
                    }
                },
                new Component() {
                    @Override
                    public ScriptPath script(RequestClient requestClient) {
                        return ScriptPath.build("com/fr/plugin/web/tokenConfig.js");
                    }
                }
        };
    }

    public ScriptPath script(RequestClient client ) {
        //如果不需要就直接返回  ScriptPath.EMPTY
        return ScriptPath.build("com/fr/plugin/web/ipConfig.js");
    }


    public StylePath style(RequestClient client ) {
        //如果不需要就直接返回 StylePath.EMPTY;
        return StylePath.build("com/fr/plugin/web/iptoken.css");
    }
}
