package com.fr.plugin.config;

import com.fr.config.ConfigContext;
import com.fr.config.DefaultConfiguration;
import com.fr.config.holder.Conf;
import com.fr.config.holder.factory.Holders;


public class MyConfig extends DefaultConfiguration {
    private static MyConfig config = null;

    public static MyConfig getInstance(){
        if (config == null){
            config = ConfigContext.getConfigInstance(MyConfig.class);
        }
        return config;
    }

    public String getNameSpace(){
        return "dwConfig";
    }

    private Conf<Integer> MinSource = Holders.simple(60);
    private Conf<Integer> MaxSource = Holders.simple(100);

    public Integer getMinSource() {
        return MinSource.get();
    }

    public void setMinSource(Integer minSource) {
        this.MinSource.set(minSource);
    }

    public Integer getMaxSource() {
        return MaxSource.get();
    }

    public void setMaxSource(Integer maxSource) {
        this.MaxSource.set(maxSource);
    }
}
