package com.fr.plugin.config;

import com.fr.config.*;
import com.fr.config.holder.Conf;
import com.fr.config.holder.factory.Holders;
import com.fr.stable.StringUtils;

@Visualization(category = "Plugin-Config_Demo")
public class MySimpleConfig extends DefaultConfiguration {
    private static volatile MySimpleConfig config = null;

    public static MySimpleConfig getInstance(){
        if (config == null) {
            config = ConfigContext.getConfigInstance(MySimpleConfig.class);
        }
        return config;
    }

    @Identifier(value = "text", name = "Plugin-Config_Property_Text", description = "", status = Status.SHOW)
    private Conf<String> text = Holders.simple(StringUtils.EMPTY);

    public String getText() {
        return text.get() ;
    }

    public void setText(String text) {
        this.text.set(text);
    }

    @Override
    public Object clone() throws CloneNotSupportedException{
        MySimpleConfig mySimpleConfig = (MySimpleConfig)super.clone();
        mySimpleConfig.text = (Conf<String>) text.clone();
        return mySimpleConfig;
    }
}
