package com.fr.plugin.filter;

import com.fr.decision.authority.data.User;
import com.fr.decision.fun.impl.AbstractGlobalRequestFilterProvider;
import com.fr.decision.webservice.utils.DecisionServiceConstants;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.plugin.IpTokenDecisionDBAccessProvider;
import com.fr.plugin.dao.UserIpDao;
import com.fr.plugin.entity.UserIpEntity;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.web.utils.WebUtils;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class IpGlobalRequestFilter  extends AbstractGlobalRequestFilterProvider {
    @Override
    public String filterName() {
        return "iptokn";
    }

    @Override
    public String[] urlPatterns() {
        return new String[]{
                "/decision/*"
        };
    }

    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain){
        try {
            if (isLogin(req)) {
                String currentUserName = LoginService.getInstance().getCurrentUserNameFromRequestCookie(req);
                String currentUserId = UserService.getInstance().getCurrentUserId(currentUserName);
                if (!UserService.getInstance().isAdmin(currentUserId)){
                    String ip = getIp(req);
                    if(!checkUserCanLoginOnIp(currentUserName, ip)){
                        WebUtils.printAsString(res, "Բ" + ip + "¼!");
                        return;
                    }
                }
            }
            filterChain.doFilter(req, res);
        }catch (IOException | ServletException ignored){

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getIp(HttpServletRequest req){
        return req.getRemoteAddr();
    }

    private boolean checkUserCanLoginOnIp(String userName, String ip) throws Exception {
        DBAccessor dbAccessor = IpTokenDecisionDBAccessProvider.getDbAccessor();
        List<UserIpEntity> entities = dbAccessor.runQueryAction(daoContext ->
                daoContext.getDAO(UserIpDao.class).find(
                        QueryFactory.create().addRestriction(RestrictionFactory.eq("ip", ip))
                                .addRestriction(RestrictionFactory.eq("userName", userName))
                )
        );
        return !entities.isEmpty();
    }

    private boolean isLogin(HttpServletRequest req) {
        return LoginService.getInstance().isLogged(req);
    }
}
