package com.fr.plugin.filter;

import com.fr.decision.authority.data.User;
import com.fr.decision.fun.impl.AbstractGlobalRequestFilterProvider;
import com.fr.decision.webservice.utils.DecisionServiceConstants;
import com.fr.decision.webservice.v10.login.LoginService;
import com.fr.decision.webservice.v10.user.UserService;
import com.fr.plugin.IpTokenDecisionDBAccessProvider;
import com.fr.plugin.dao.UserTokenDao;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.restriction.RestrictionFactory;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class TokenGlobalRequestFilter extends AbstractGlobalRequestFilterProvider {
    @Override
    public String filterName() {
        return "iptoken";
    }

    @Override
    public String[] urlPatterns() {
        return new String[]{
                "/decision/*"
        };
    }

    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain){
        try {
            if (!isLogin(req)) {
                login(req, res);
            }
            filterChain.doFilter(req, res);
        }catch (IOException | ServletException ignored){

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void login(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String my_token = req.getParameter("token");
        if (StringUtils.isNotBlank(my_token)){
            String userName = getUserNameByToken(my_token);
            User user = UserService.getInstance().getUserByUserName(userName);
            if(user != null){
                String token = LoginService.getInstance().login(req, res, userName);
                req.setAttribute(DecisionServiceConstants.FINE_AUTH_TOKEN_NAME, token);
            }
        }
    }

    private String getUserNameByToken(String token) throws Exception {
        DBAccessor dbAccessor = IpTokenDecisionDBAccessProvider.getDbAccessor();
        List<UserTokenEntity> entities = dbAccessor.runQueryAction(
                daoContext ->
                        daoContext.getDAO(UserTokenDao.class).find(QueryFactory.create().addRestriction(RestrictionFactory.eq("token", token))));
        if (!entities.isEmpty()){
            return entities.get(0).getUserName();
        }
        return "";
    }

    private boolean isLogin(HttpServletRequest req) {
        return LoginService.getInstance().isLogged(req);
    }
}
