package com.fr.plugin.http;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.IpTokenDecisionDBAccessProvider;
import com.fr.plugin.dao.UserIpDao;
import com.fr.plugin.entity.UserIpEntity;
import com.fr.stable.StringUtils;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.UUID;

public class AddIpApi extends BaseHttpHandler {
    @Override
    public RequestMethod getMethod() {
        return null;
    }

    @Override
    public String getPath() {
        return "/addIp";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DBAccessor dbAccessor = IpTokenDecisionDBAccessProvider.getDbAccessor();

//        String userName = WebUtils.getHTTPRequestParameter(httpServletRequest, "userName");
//        String ip = WebUtils.getHTTPRequestParameter(httpServletRequest, "ip");
        String body = getBody(httpServletRequest);
        JSONObject entries = new JSONObject(body);

        String userName = entries.getString("userName");
        String ip = entries.getString("ip");
        if (StringUtils.isBlank(userName) || StringUtils.isBlank(ip)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", "user name or ip is blank");
            jsonObject.put("code", "-1");
            WebUtils.printAsJSON(httpServletResponse, jsonObject);
        }


        UserIpEntity userIpEntity = new UserIpEntity();
        userIpEntity.setUserName(userName);
        userIpEntity.setIp(ip);
        userIpEntity.setId(UUID.randomUUID().toString());

        dbAccessor.runDMLAction(daoContext -> {
            daoContext.getDAO(UserIpDao.class).add(userIpEntity);
            return null;
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", "add success");
        jsonObject.put("code", 200);
        WebUtils.printAsJSON(httpServletResponse, jsonObject);
    }

    String getBody(HttpServletRequest request) throws IOException {
        BufferedReader bufferedReader = request.getReader();
        String str;
        StringBuilder stringBuilder = new StringBuilder();
        while ((str = bufferedReader.readLine()) != null){
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }
}
