package com.fr.plugin.http;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.IpTokenDecisionDBAccessProvider;
import com.fr.plugin.dao.UserTokenDao;
import com.fr.plugin.entity.UserTokenEntity;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.UUID;

public class AddTokenApi extends BaseHttpHandler {
    @Override
    public RequestMethod getMethod() {
        return null;
    }

    @Override
    public String getPath() {
        return "/addToken";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DBAccessor dbAccessor = IpTokenDecisionDBAccessProvider.getDbAccessor();

//        String userName = WebUtils.getHTTPRequestParameter(httpServletRequest, "userName");
//        String token = WebUtils.getHTTPRequestParameter(httpServletRequest, "token");

        String body = getBody(httpServletRequest);
        JSONObject entries = new JSONObject(body);

        String userName = entries.getString("userName");
        String token = entries.getString("token");

        UserTokenEntity userTokenEntity = new UserTokenEntity();
        userTokenEntity.setUserName(userName);
        userTokenEntity.setToken(token);
        userTokenEntity.setId(UUID.randomUUID().toString());

        dbAccessor.runDMLAction(daoContext -> {
            daoContext.getDAO(UserTokenDao.class).add(userTokenEntity);
            return null;
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", "add success");
        jsonObject.put("code", 200);
        WebUtils.printAsJSON(httpServletResponse, jsonObject);
    }

    String getBody(HttpServletRequest request) throws IOException {
        BufferedReader bufferedReader = request.getReader();
        String str;
        StringBuilder stringBuilder = new StringBuilder();
        while ((str = bufferedReader.readLine()) != null){
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }
}
