package com.fr.plugin.http;

import com.fr.decision.fun.impl.BaseHttpHandler;
import com.fr.json.JSONObject;
import com.fr.plugin.IpTokenDecisionDBAccessProvider;
import com.fr.plugin.dao.UserIpDao;
import com.fr.stable.db.accessor.DBAccessor;
import com.fr.stable.query.QueryFactory;
import com.fr.stable.query.condition.QueryCondition;
import com.fr.stable.query.restriction.RestrictionFactory;
import com.fr.third.org.apache.commons.lang3.StringUtils;
import com.fr.third.springframework.web.bind.annotation.RequestMethod;
import com.fr.web.utils.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;

public class DelIpApi extends BaseHttpHandler {
    @Override
    public RequestMethod getMethod() {
        return null;
    }

    @Override
    public String getPath() {
        return "/delIp";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DBAccessor dbAccessor = IpTokenDecisionDBAccessProvider.getDbAccessor();

        String body = getBody(httpServletRequest);
        JSONObject entries = new JSONObject(body);

        String id = entries.getString("id");

        QueryCondition queryCondition = QueryFactory.create().addRestriction(RestrictionFactory.eq("id", id));

        if (StringUtils.isNotBlank(id)) {
//            queryCondition.addRestriction(RestrictionFactory.eq("userName", userName));
            dbAccessor.runDMLAction(daoContext -> {
                daoContext.getDAO(UserIpDao.class).remove(queryCondition);
                return null;
            });
        } else {

        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", "remove success");
        jsonObject.put("code", 200);
        WebUtils.printAsJSON(httpServletResponse, jsonObject);
    }

    String getBody(HttpServletRequest request) throws IOException {
        BufferedReader bufferedReader = request.getReader();
        String str;
        StringBuilder stringBuilder = new StringBuilder();
        while ((str = bufferedReader.readLine()) != null){
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }
}
