!(function(){
    BI.config("dec.constant.system.tabs", function (items) {
        items.push({
            value: "ipToken",
            text: BI.i18nText("IP配置"),  // 文字
            cardType: "dec.management.ipConfig"
        });
        return items;
    });

    BI.config("dec.constant.menu.items", function (items) {
        items.push({
            value: "baidu",
            text: BI.i18nText("百度一下"),
            cardType:{
                src:"http://baidu.com"
            },
            cls: "analysis-menu-font"
        });
        return items;
    });

    function resolvePath(path, isPublic){
        if(!path || path[0] !== '/'){
            path = '/' + path;
        }
        return isPublic === true
            ? '/plugin/public/com.fr.plugin.dw.dw.7.project' + path
            : '/plugin/private/com.fr.plugin.dw.dw.7.project' + path;
    }

    var ipConfig = BI.inherit(BI.Widget, {
        props: {
            baseCls: "ipConfig"
        },
        render: function(){
            var self = this;
            return {
                type: "bi.absolute",
                items: [
                    {
                        el:{
                            type: "bi.button",
                            text: "添加",
                            handler: function() {
                                var id = "addUserPane"
                                var that = this;

                                BI.Popovers.create(id, {
                                        type: "bi.bar_popover",
                                      // String或者是json都行
                                      header: "添加IP限制",
                                      size: "small",
                                      body: {
                                        type: "bi.add.userTokenOrIp",
                                        cType: "ip",
                                        ref: function(e){
                                            that.userIpPane = e;
                                        }
                                      },
                                      listeners:[{
                                        eventName: "EVENT_CANCEL",
                                        action: function(){
                                            BI.Msg.toast("点击了取消")
                                        }
                                        },{
                                            eventName: "EVENT_CONFIRM",
                                            action: function(){
                                                var params = that.userIpPane.getValue();
                                                console.info(params)
                                                Dec.reqPost(resolvePath("/addIp", false), {
                                                    userName: params.userName,
                                                    ip: params.params2
                                                }, function(){
                                                    BI.Msg.toast("保存成功")
                                                    self.tableRef.reload();
                                                })
                                            }

                                      }]
                                }).open(id);
                            }
                        },
                        top: 0,
                        left: 0,
                    },
                    {
                        el:{
                            type: "bi.button",
                            text: "刷新",
                            handler: function(){
                                self.tableRef.reload();
                            }
                        },
                        top: 0,
                        left: 100,
                    },
                    {
                        el:{
                            type: "dec.management.iptoken.table",
                            tableType: "ipTable",
                            ref:function(e){
                                self.tableRef = e;
                            }
                        },
                        top: 40,
                        left: 0,
                        right: 0,
                        bottom: 0
                    }
                ]
            };
        }
    });

    BI.shortcut("dec.management.ipConfig", ipConfig);
}());