;(function(){
    //debugger
    var IpHeader = [[{
        text:"id",
    },{
        text:"用户名",
    },{
        text:"IP",
    },{
        text:"操作"
    }]];
    var TokenHeader = [[{
         text:"id",
    },{
        text:"用户名",
    },{
        text:"Token",
    },{
        text:"操作"
    }]];
    function resolvePath(path, isPublic){
            if(!path || path[0] !== '/'){
                path = '/' + path;
            }
            return isPublic === true
                ? '/plugin/public/com.fr.plugin.dw.dw.7.project' + path
                : '/plugin/private/com.fr.plugin.dw.dw.7.project' + path;
    }

    var IPAndTokenTable = BI.inherit(BI.Widget, {
        props:{
            baseCls: "iptoken-table",
            tableType:"ipTable"
        },
        beforeInit: function(render){
            var that = this;
            this.getData(function(data){
                that.allData = data;
                render();
            })
        },
        getData: function(callBack){
            var that = this;
            var url="/listToken";
            if(this.options.tableType === "ipTable"){
                url = "/listIp"
            }
            Dec.reqGet(
                resolvePath(url, false)
                ,{}
                ,function(data){
                    var tempData = BI.map(data, function(i, v){
                        return BI.map(v, function(ii, vv){
                            return {
                                text:vv,
                                whiteSpace:"normal"
                            }
                        })
                    });
                    BI.each(tempData, function(i, v){
                        v.push({
                            type: "bi.button",
                            text: "删除",
                            handler: function(){
                                var id = v[0].text;
                                var url = "/delToken";
                                if(that.options.tableType === "ipTable"){
                                    url = "/delIp"
                                }
                                Dec.reqDelete(resolvePath(url, false), {
                                    id: id
                                }, function(){
                                    that.reload();
                                })
                            }
                        })
                    });
                    callBack(tempData);
                });
        },
        reload: function(){
            var that = this;
            this.getData(function(data){
                that.tableIns.populate(data)
            })
        },
        render: function(){
            var that = this;
            var header = TokenHeader;
            if(this.options.tableType === "ipTable"){
                header = IpHeader;
            }
            return {
                type: "bi.table_view",
                width: 600,
                height: 400,
                ref: function(e){
                    that.tableIns = e;
                },
                minColumnSize: [100, 100, 100],
                columnSize: [100, 100, 100],
                regionColumnSize: [300, "fill"],
                items: this.allData,
                header: header,
            }
        }
    });
    BI.shortcut("dec.management.iptoken.table", IPAndTokenTable);
})();