;(function(){

    BI.config("dec.constant.management.navigation", function(items){
        items.push({
            value: "iptoken",
            id:"ipToken-1",
            text: BI.i18nText("Token配置"),  // 文字
            cardType: "dec.management.tokenConfig",
            cls: "management-directory-font"
        });
        return items;
    })

    function resolvePath(path, isPublic){
        if(!path || path[0] !== '/'){
            path = '/' + path;
        }
        return isPublic === true
            ? '/plugin/public/com.fr.plugin.dw.dw.7.project' + path
            : '/plugin/private/com.fr.plugin.dw.dw.7.project' + path;
    }

    var tokenConfig = BI.inherit(BI.Widget, {
        props: {
            baseCls: "tokenConfig"
        },
        render: function(){
            var self = this;
            return {
                type: "bi.absolute",
                items: [
                    {
                        el:{
                            type: "bi.button",
                            text: "添加",
                            handler: function() {
                                var id = "addUserPane"
                                var that = this;

                                BI.Popovers.create(id, {
                                        type: "bi.bar_popover",
                                      // String或者是json都行
                                      header: "添加Token限制",
                                      size: "small",
                                      body: {
                                        type: "bi.add.userTokenOrIp",
                                        cType: "token",
                                        ref: function(e){
                                            that.userIpPane = e;
                                        }
                                      },
                                      listeners:[{
                                        eventName: "EVENT_CANCEL",
                                        action: function(){
                                            BI.Msg.toast("点击了取消")
                                        }
                                        },{
                                            eventName: "EVENT_CONFIRM",
                                            action: function(){
                                                var params = that.userIpPane.getValue();
                                                console.info(params)
                                                Dec.reqPost(resolvePath("/addToken", false), {
                                                    userName: params.userName,
                                                    token:params.params2
                                                }, function(){
                                                    BI.Msg.toast("保存成功")
                                                    self.tableRef.reload();
                                                })
                                            }

                                      }]
                                }).open(id);
                            }
                        },
                        top: 0,
                        left: 0,
                    },
                    {
                        el:{
                            type: "bi.button",
                            text: "刷新",
                            handler: function(){
                                self.tableRef.reload();
                            }
                        },
                        top: 0,
                        left: 100,
                    },
                    {
                        el:{
                            type: "dec.management.iptoken.table",
                            tableType: "tokenTable",
                            ref:function(e){
                                self.tableRef = e;
                            }
                        },
                        top: 40,
                        left: 0,
                        right: 0,
                        bottom: 0
                    }
                ]
            };
        }
    });
    BI.shortcut("dec.management.tokenConfig", tokenConfig);
})();