/**
 * @class FR.RHIframe
 * @extends FR.BaseEditor
 */
(function ($) {

    FR.RHIframe = FR.extend(FR.BaseEditor, {

        _defaultConfig: function () {
            return $.extend(FR.RHIframe.superclass._defaultConfig.apply(), {
                baseName: 'rh.iframe',
                baseClass: 'fr_iframeeditor',//ezreal:REPORT-36180 报表只会对框架是这个class做了滚动条的兼容
                widgetName: "",
                src: "",
                width: "100%",
                height: "100%",
                showOverFlowX: true,
                showOverFlowY: true,
                para: {}
            });
        },
        isFirst: true,
        para: {},
        /**
         * 初始化数据
         * @protected
         */
        initData: function () {
            if (this.options.data) {
                return;
            }
            if (this.options.widgetUrl) {
                this.options.data = FR.DataFactory
                    .createJSONData(this.options.widgetUrl, this.options);
            } else if (this.options.items) {
                this.options.data = FR.DataFactory
                    .createArrayData(this.options.items, this.options);
            }
        },
        _init: function () {
            FR.RHIframe.superclass._init.apply(this, arguments);
            this.initData();
            this._iframeInit();
            // 控件属性


        },
        _iframeInit: function () {
            var o = this.options;
            var self = this;
            this.editComp = this.element.css({
                width: '100%',
                height: '100%'
            }).attr("flag", Math.random());
            o.iframeName = o.widgetName || this.createNoRepeatName();
            this.$iframe =
                $("<iframe  name=" + o.iframeName + " id=" + (o.iframeName + this.createNoRepeatName()) + ">")
                    .addClass(o.baseClass)
                    // .addClass("fr_iframeeditor")
                    .attr({
                        frameborder: 0,
                        scrolling: !o.showOverFlowX && !o.showOverFlowY ? 'no' : 'yes',
                        allowfullscreen: true
                    }).appendTo(this.editComp);
            // 部分浏览器 渲染机制会先展示 iframe 然后加载 iframe 内容最后展示内容
            // 如果 iframe 内加载时间长，会有一段长时间的空白
            // 因此先将 iframe 隐藏掉，在 load 事件再显示出来
            var $iframe = this.$iframe;
            $iframe.hide();
            //   self.editComp.hide();
            // 这里滚动条的设置 跟子页面的设置有关
            // 如果嵌入的是我们的报表或者表单 window的尺寸都是100%那就取了iframe的大小
            // 如果报表或表单内容尺寸超过的话 就会出现滚动条 那么就改下子元素 这时一般不跨域
            var serverUrl = FR.servletURL;

            /**表单和 cpt分开处理吧，表单不知道为什么会加载两次,直接在第一次加载的回调里面放网页框的地址
             * cpt的话直接在这个初始化的方法里面加载网页框地址
             */
            if (self._isfrm()) {//表单里面网页框
                //表单的网页框直接100%
                $iframe.attr({
                    width: "100%",
                    height: "100%"
                });
            } else {//cpt里面的
                //cpt里的网页框必须要设置成单元格的高度,要不然会在单元格里面无法充满
                $iframe.attr({
                    width: o.width,
                    height: o.height
                });
            }

            // IE里面需要设置rowspan为1才能正常显示....否则会跳过n行不显示，chrome应该是bug，一会儿好一会儿不好
            if ($.browser.msie &&
                (this.$iframe.parent()).is("div") &&
                (this.$iframe.parent().parent()).is("td") &&
                (this.$iframe.parent().parent().attr("widget")) != null &&
                (this.$iframe.parent().parent().parent()).is("tr")) {
//            this.$iframe.parent().parent().attr('rowspan', '1');
                // 上面这么搞有问题的，IE7或IE8杂项下，合并单元格中的网页框控件会只显示在第一行的，改成下面
                this.$iframe.parent().height("");
            } else {
                this.$iframe.css('overflow-x', o.showOverFlowX ? 'auto' : 'hidden');
                this.$iframe.css('overflow-y', o.showOverFlowY ? 'auto' : 'hidden');
            }
            if (o.disabled) {
                this._addDisableMask();
            }
            $iframe.show();
            if (self._isfrm()) {//表单里面网页框
                $iframe.on("load", function () {
                    if (self.isFirst) {
                        self.isFirst = false;
                        if (o.controlAttr) {
                            var result = o.controlAttr;
                            self.setValue(result);
                        } else if (o.src) {
                            self.setValue(o.src);
                        }
                    }
                });
            } else {//cpt里面的
                //cpt里的网页框必须要设置成单元格的高度,要不然会在单元格里面无法充满
                if (o.controlAttr) {
                    var result = o.controlAttr;
                    self.setValue(result);
                } else if (o.src) {
                    self.setValue(o.src);
                }
                self.isFirst = false;
            }

        },
        _isfrm: function () {
            var serverUrl = FR.servletURL;
            return serverUrl.endWith("form");
        },
        hideDealSrc: function (src, width, height) {
            if (this.options.sourceType == 'tpl') {
                src = this.changeURLArg(src, "width", width);
                src = this.changeURLArg(src, "height", height);
            }
            return src;
        },

        createNoRepeatName: function () {
            return this.options.baseName + Math.random();
        },
        encodeURL: function (str, isTpl) {
            var self = this;
            if (isTpl) {
                return self._encodeURLWithTpl(str);
            }
            var isEncode = self.options.customUrlEncode
            return self._encodeURLWithCustom(str, isEncode);
        },
        _encodeURLWithTpl: function (str) {
            if (FR.isEmpty(str)) {
                return str;
            }
            var num = str.indexOf("?");
            if (num < 0) {
                return str;
            }
            var url = str.substr(0, num + 1);
            var paraStr = str.substr(num + 1);
            var arr = paraStr.split("&"); //各个参数放到数组里
            var name, value;
            for (var i = 0; i < arr.length; i++) {
                var index = arr[i].indexOf("=");
                if (index > 0) {
                    name = arr[i].substring(0, index);
                    value = arr[i].substr(index + 1);
                    try {
                        name = decodeURIComponent(name);
                        value = decodeURIComponent(decodeURIComponent(value));
                    } catch (e) {
                    }
                    name = encodeURIComponent(name);
                    value = encodeURIComponent(value);
                    value = encodeURIComponent(value);//模板的话就多加工一次
                    url = url + (i > 0 ? "&" : "") + name + "=" + value;
                } else {
                    value = arr[i];
                    try {
                        value = decodeURIComponent(value);
                    } catch (e) {
                    }
                    value = encodeURIComponent(value);
                    url = url + (i > 0 ? "&" : "") + value;
                }
            }
            return url;
        },
        _encodeURLWithCustom: function (str, isEncode) {
            if (!isEncode) {
                return str;
            }
            if (FR.isEmpty(str)) {
                return str;
            }
            var num = str.indexOf("?");
            if (num < 0) {
                return str;
            }
            var url = str.substr(0, num + 1);
            var paraStr = str.substr(num + 1);
            var arr = paraStr.split("&"); //各个参数放到数组里
            var name, value;
            for (var i = 0; i < arr.length; i++) {
                var index = arr[i].indexOf("=");
                if (index > 0) {
                    name = arr[i].substring(0, index);
                    value = arr[i].substr(index + 1);
                    try {
                        name = decodeURIComponent(name);
                        value = decodeURIComponent(value);
                    } catch (e) {
                    }
                    name = encodeURIComponent(name);
                    value = encodeURIComponent(value);
                    url = url + (i > 0 ? "&" : "") + name + "=" + value;
                } else {
                    value = arr[i];
                    try {
                        value = decodeURIComponent(value);
                    } catch (e) {
                    }
                    value = encodeURIComponent(value);
                    url = url + (i > 0 ? "&" : "") + value;
                }
            }
            return url;
        },

        _loadIframeByGet: function () {
            var self = this;
            var src = this.encodeURL(this.options.src, self.options.sourceType === 'tpl');
            //ez:传递参数的时候这个this.options.src是空的，这个时候直接获取现有的src属性
            if (FR.isEmpty(src)) {
                src = this.getValue();
            }
            if (this.options.data) {
                this.options.data.resetStatus(this.createDependencePara4Data());//ezreal:需要重新拿着联动参数去后台取数
                var waitForInitComplete = [];
                var backupQuery = {};
                for (var i = 0, len = this.options.data.getLength(); i < len; i++) {
                    var params = this.options.data.getRecord(i).getContent();
                    if (typeof params == 'object' && params.widgetName && this.options.form) {
                        var w = this.options.form.getWidgetByName(params.widgetName);
                        if (w) {
                            var para = {};
                            para[params.widgetName] = w.getValue();
                            src = src.appendQuery(para);
                        } else {
                            waitForInitComplete.push(params.widgetName);
                        }
                    } else {
                        $.extend(backupQuery, params);
                    }
                }
                src = self._appendQuery(src, backupQuery);

                if (waitForInitComplete.length > 1) {
                    var form = this.options.form;
                    form.on(FR.Events.AFTERINIT, function () {
                        for (var c = 0; c < waitForInitComplete.length; c++) {
                            var name = waitForInitComplete[c];
                            var para = {};
                            para[name] = form.getWidgetByName(name).getValue();
                            src = src.appendQuery(para);
                        }
                        self._changeIframe(src);
                    });

                }
            }
            this._changeIframe(src);
        }
        ,
        /**
         * 给url加上给定的参数
         * @param {String} src 原地址
         * @param {Object} paras 参数对象，是一个键值对对象
         * @return {String} 添加了给定参数的url
         */
        _appendQuery: function (src, paras) {
            var self = this;
            if (FR.isEmptyObj(paras)) {
                return src;
            }
            // 模板
            if (self.options.sourceType == 'tpl') {
                var cpParas = {};
                $.each(paras, function (pName, pValue) {
                    //后端没有encode,那就前端做
                    cpParas[encodeURIComponent(pName)] = encodeURIComponent(pValue);
                });
                //ezreal:这个东西需要替换或者新增 的方式加上参数
                src = self.changeURLArg(src, "__parameters__", encodeURIComponent(FR.jsonEncode(cpParas)));
                //  src += "__parameters__=" + encodeURIComponent(FR.jsonEncode(cpParas));
            } else {
                $.each(paras, function (name, value) {
                    // web链接的参数不进行额外处理。
                    if (typeof (name) === 'string') {
                        src = self.changeURLArg(src, encodeURIComponent(decodeURIComponent(name)), encodeURIComponent(decodeURIComponent(value)));
                        // src += name + "=" + value + "&";
                    }
                });
            }

            return src;
        },
        /**
         * 添加一层遮罩层，用于屏蔽iframe内容的可用性
         * @private
         */
        _addDisableMask: function () {
            this.mask = $('<span/>').css({
                backgroundColor: '#66B9FF',
                height: this.options.height,
                width: this.options.width,
                left: this.element.offset().left
            }).appendTo(this.element);
        }
        ,

        /**
         *
         * 设置网页框控件的地址并重新加载页面(保留原参数)
         * @param {String} v 新的地址
         */
        setValue: function (v, para) {
            if (!FR.isEmpty(v)) {
                this.options.src = v;
                this.options.para = FR.extend(this.options.para, UrlSearch(v));
            }
            if (para instanceof Object) {
                this.options.para = FR.extend(this.options.para, para);
            }

            function UrlSearch(str) {
                if (FR.isEmpty(str)) {
                    return {};
                }
                var result = {}
                var name, value;
                var num = str.indexOf("?")
                str = str.substr(num + 1); //取得所有参数   stringvar.substr(start [, length ]

                var arr = str.split("&"); //各个参数放到数组里
                console.log(arr)
                for (var i = 0; i < arr.length; i++) {
                    num = arr[i].indexOf("=");
                    if (num > 0) {
                        name = arr[i].substring(0, num);
                        value = arr[i].substr(num + 1);
                        result[name] = value;
                    }
                }
                return result;
            }

            this._loadIframe();
        },
        /**
         * 加载Iframe
         * @private
         */
        _loadIframe: function () {
            if (this._isGetMethod()) {
                this._loadIframeByGet();
            } else {
                this._loadIframeByPost()
            }

        },
        /**
         * Post方式加载
         * @private
         */
        _loadIframeByPost: function () {
            var self = this;
            var src = this.encodeURL(this.options.src, self.options.sourceType === 'tpl');
            //ez:传递参数的时候这个this.options.src是空的，这个时候直接获取现有的src属性
            if (FR.isEmpty(src)) {
                src = this.getValue();
            }
            if (this.options.data) {
                this.options.data.resetStatus(this.createDependencePara4Data());//ezreal:需要重新拿着联动参数去后台取数
                var waitForInitComplete = [];
                var backupQuery = {};
                for (var i = 0, len = this.options.data.getLength(); i < len; i++) {
                    var params = this.options.data.getRecord(i).getContent();
                    if (typeof params == 'object' && params.widgetName && this.options.form) {
                        var w = this.options.form.getWidgetByName(params.widgetName);
                        if (w) {
                            var para = {};
                            para[params.widgetName] = w.getValue();
                        } else {
                            waitForInitComplete.push(params.widgetName);
                        }
                    } else {
                        $.extend(backupQuery, params);
                    }
                }
                if (waitForInitComplete.length > 1) {
                    var form = this.options.form;
                    form.on(FR.Events.AFTERINIT, function () {
                        for (var c = 0; c < waitForInitComplete.length; c++) {
                            var name = waitForInitComplete[c];
                            var para = {};
                            para[name] = form.getWidgetByName(name).getValue();
                            $.extend(backupQuery, para);
                        }
                    });
                }
                self.options.para = $.extend(self.options.para, backupQuery);
            }
            this._changeIframe(src);
        },
        /**
         * 判断是不是get请求
         * @returns {boolean}
         * @private
         */
        _isGetMethod: function () {
            return this.options.method === "GET";
        },

        /**
         * 获取网页框的src地址
         * @returns {String} 地址
         */
        getValue: function () {
            return this._isGetMethod() ? this.$iframe.attr("src") : this.options.src;
        },
        _dealValueWithEvents: function (src) {
            this.options.src = src;
            this._changeIframe(src);
        },
        /**
         * 改变iframe的src指向的地址
         * @param src 新的地址
         * @private
         */
        _changeIframe: function (src) {
            var self = this;
            var serverUrl = FR.servletURL;
            if (serverUrl.endWith("form")) {
                var height = this.options.elShowHeight > 0 ? this.options.elShowHeight : self.element.height();
                var width = this.options.elShowWidth > 0 ? this.options.elShowWidth : self.element.width();
                src = self.hideDealSrc(src, width, height);
            }
            if (this._isGetMethod()) {
                this._changeIframeGet(src);
            } else {
                this._changeIframePost(src, this.options.para);
            }
        },
        /**
         * post方式提交iframe
         * @param src
         * @param para
         * @private
         */
        _changeIframePost: function (src, para) {
            function post(URL, PARAMS, target) {
                var temp_form = document.createElement("form");
                temp_form.action = URL;
                temp_form.target = target;
                temp_form.method = "post";
                temp_form.style.display = "none";
                for (var x in PARAMS) {
                    var opt = document.createElement("textarea");
                    opt.name = x;
                    opt.value = PARAMS[x];
                    temp_form.appendChild(opt);
                }
                document.body.appendChild(temp_form);
                temp_form.submit();
                temp_form.remove();
            }

            var self = this, o = this.options;
            //  if ($("[name='" + o.iframeName + "']").size() > 0) {
            post(src, para, o.iframeName);
            //}
        },
        _changeIframeGet: function (src) {
            this.$iframe.attr("src", src);
        },
        isIframeloaded: function () {
            var self = this, o = this.options;
            return $("[name='" + o.iframeName + "']").size() > 0
        },

        /**
         * 加载指定的url
         * @param url 网页地址
         */
        loadUrl: function (url) {
            this.$iframe.attr("src", url);
        }
        ,

        setEnable: function (enable) {
            FR.RHIframe.superclass.setEnable.apply(this, arguments);
            if (enable) {
                if (this.mask) {
                    this.mask.remove();
                }
            } else {
                if (this.mask) {
                    this.mask.show();
                } else {
                    this._addDisableMask();
                }
            }
        },

        doResize: function (give) {
            var self = this, o = this.options;
            if ((!self.isFirst) && o.contentAdapt) {
                this.reload();
            }
        }
        ,

        /**
         * 重置网页框控件
         */
        reload: function () {
            this.options.data.clearData();
            this._loadIframe();
        }
        ,
        refresh: function () {
            this.postMessage({EVENT_NAME: 'EVENT_REFRESH'})
        },
        postMessage: function (data, origin) {
            if (!origin) {
                origin = "*";
            }
            (this.$iframe)[0].contentWindow.postMessage(data, origin);
        },
        /**
         *
         * url 目标url
         * arg 需要替换的参数名称
         * arg_val 替换后的参数的值
         * return url 参数替换后的url
         */
        changeURLArg: function (url, arg, arg_val) {
            var pattern = arg + '=([^&]*)';
            var replaceText = arg + '=' + arg_val;
            if (url.match(pattern)) {
                var tmp = '/(' + arg + '=)([^&]*)/gi';
                tmp = url.replace(eval(tmp), replaceText);
                return tmp;
            } else {
                if (url.match('[\?]')) {
                    return url + '&' + replaceText;
                } else {
                    return url + '?' + replaceText;
                }
            }
            return url + '\n' + arg + '\n' + arg_val;
        }
    });
    $.shortcut('rh.iframe', FR.RHIframe);
})(jQuery);
!(function () {
    try {
        var provider = BI.Providers.getProvider("report.resizable_componenets.provider");
    } catch (e) {
        return;
    }

    var ImplClass = provider.getImpl();

    var Widget = BI.inherit(ImplClass, {
        hideDealSrc: function () {
            this.widget && this.widget.hideDealSrc.apply(this.widget, arguments);
        },

        setValue: function () {
            this.widget && this.widget.setValue.apply(this.widget, arguments);
        },

        getValue: function () {
            return (this.widget && this.widget.getValue.apply(this.widget, arguments));
        },

        resize: function (width, height) {
            this.container.element.width(width)
                .height(height);

            this.widget && this.widget.doResize({
                width: width,
                height: height
            });
        },

        loadUrl: function () {
            this.widget && this.widget.loadUrl.apply(this.widget, arguments);
        },

        setEnable: function (enable) {
            Widget.superclass.setEnable.apply(this, arguments);
            this.widget && this.widget.setEnable.apply(this.widget, arguments);
        },
        setVisible: function (visible) {
            Widget.superclass.setVisible.apply(this, arguments);
            this.widget && this.widget.setVisible.apply(this.widget, arguments);
        },

        changeURLArg: function () {
            this.widget && this.widget.changeURLArg.apply(this.widget, arguments);
        },

        refresh: function () {
            this.widget && this.widget.refresh();
        },

        reload: function () {
            this.widget && this.widget.reload();
        },

        render: function () {
            var self = this;

            return {
                type: "bi.absolute",
                items: [{
                    el: {
                        type: "bi.layout",
                        ref: function (_ref) {
                            self.container = _ref;
                        }
                    },
                    top: 0,
                    left: 0,
                    width: "100%",
                    height: "100%"
                }]
            }
        },

        mounted: function () {
            this.widget = FR.createWidget(BI.extend({}, this.options, {
                type: 'rh.iframe',
                renderEl: this.container.element[0]
            }));

            // Fineui和FR生命周期不同，需要主动触发load事件
            this.widget.$iframe.trigger('load');
        },
        linkageUpdate: function () {
            this.widget && this.widget.reload();
        }
    });

    Widget.xtype = "report.rh.iframe";

    BI.shortcut(Widget.xtype, Widget);

    provider.set('rh.iframe', Widget.xtype);
})();